<?php
	global $VISUAL_COMPOSER_EXTENSIONS;	
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                          => __( "TS iFrame Embed", "ts_visual_composer_extend" ),
		"base"                          => "TS-VCSC-IFrame",
		"icon" 	                        => "ts-composer-element-icon-iframe",
		"category"                      => __( "Composium", "ts_visual_composer_extend" ),
		"description"                   => __("Place an iFrame element", "ts_visual_composer_extend"),
		"admin_enqueue_js"              => "",
		"admin_enqueue_css"             => "",
		"params"                        => array(
			// Embed iFrame
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_1",
				"seperator"             => "iFrame Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "iFrame URL", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe",
				"value"                 => "",
				"admin_label"           => true,
				"description"           => __( "Enter the URL for the iFrame.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger",
				"color"					=> "#FF0000",
				"size"					=> "14",
				"message"            	=> __( "Please ensure that the page you are attempting to embed via iFrame is not protected by restrictive X-Frame-Options.", "ts_visual_composer_extend" ),
			),
			array(
				"type"             	 	=> "switch_button",
				"heading"               => __( "Open in Lightbox", "ts_visual_composer_extend" ),
				"param_name"            => "content_lightbox",
				"value"                 => "false",
				"admin_label"           => true,
				"description"       	=> __( "Switch the toggle to show the iFrame in a lightbox.", "ts_visual_composer_extend" )
			),
			// iFrame Dimensions
			array(
				"type"                  => "dropdown",
				"heading"               => __( "iFrame Width", "ts_visual_composer_extend" ),
				"param_name"            => "iframe_width",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )					=> "auto",
					__( 'Set Width (%)', "ts_visual_composer_extend" )        	=> "widthpercent",
					__( 'Set Width (px)', "ts_visual_composer_extend" )       	=> "widthpixel",
				),
				"description"           => __( "Select the how the iFrame Width should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "iFrame Width", "ts_visual_composer_extend" ),
				"param_name"            => "iframe_width_percent",
				"value"                 => "100",
				"min"                   => "1",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select iFrame width in percent.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_width", 'value' => 'widthpercent' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "iFrame Width", "ts_visual_composer_extend" ),
				"param_name"            => "iframe_width_pixel",
				"value"                 => "1024",
				"min"                   => "1",
				"max"                   => "2048",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select iFrame width in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_width", 'value' => 'widthpixel' )
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "iFrame Height", "ts_visual_composer_extend" ),
				"param_name"            => "iframe_height",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto 16:9 Ratio', "ts_visual_composer_extend" )			=> "auto",
					__( 'Auto Height Content (BETA)', "ts_visual_composer_extend" )	=> "content",
					__( 'Set Height (px)', "ts_visual_composer_extend" )      		=> "heightpixel",
				),
				"description"           => __( "Select the how the iFrame Height should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' )
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger",
				"color"					=> "#FF0000",
				"size"					=> "12",
				"message"            	=> __( "This  auto-height routine will only work for iFrame pages that are hosted on the same domain as the main page and use the same page protocol.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_height", 'value' => 'content' )
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Height Monitoring", "ts_visual_composer_extend" ),
				"param_name"            => "height_adjust",
				"width"                 => 150,
				"value"                 => array(
					__( 'Browser Resize', "ts_visual_composer_extend" )				=> "resize",
					__( 'Content Resize', "ts_visual_composer_extend" )				=> "watcher",
				),
				"description"           => __( "Select the when and how the iFrame height should be readjusted.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_height", 'value' => 'content' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Minimum Height", "ts_visual_composer_extend" ),
				"param_name"            => "height_minimum",
				"value"                 => "400",
				"min"                   => "0",
				"max"                   => "2048",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define a minimum height for the iFrame that should be maintained at all times.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_height", 'value' => 'content' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Height Offset", "ts_visual_composer_extend" ),
				"param_name"            => "height_offset",
				"value"                 => "0",
				"min"                   => "-200",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Define an additional (optional) offset that should be added to the determined iFrame height.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_height", 'value' => 'content' )
			),			
			/*array(
				'type' 					=> "checkbox",
				'heading' 				=> __( 'Height Measurement', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'height_measure',								
				'value' 				=> array(
					__( 'Offset Height', 'ts_visual_composer_extend' ) 			=> 'offsetHeight',
					__( 'Client Height', 'ts_visual_composer_extend' ) 			=> 'clientHeight',
					__( 'Scroll Height', 'ts_visual_composer_extend' ) 			=> 'scrollHeight',					
				),
				"std"					=> "offsetHeight",
				"default"				=> "offsetHeight,clientHeight,scrollHeight",
				"description" 			=> __( 'Select which height attribute(s) should be measured and compared in order to determine the final iFrame height.', 'ts_visual_composer_extend' ),
				"dependency"            => array( 'element' => "iframe_height", 'value' => 'content' )
			),*/		
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Watcher Interval", "ts_visual_composer_extend" ),
				"param_name"            => "height_interval",
				"value"                 => "1000",
				"min"                   => "200",
				"max"                   => "2000",
				"step"                  => "100",
				"unit"                  => 'ms',
				"description"           => __( "Define the interval at which the iFrame should be monitored for internal changes in its document height.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "height_adjust", 'value' => 'watcher' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "iFrame Height", "ts_visual_composer_extend" ),
				"param_name"            => "iframe_height_pixel",
				"value"                 => "400",
				"min"                   => "100",
				"max"                   => "4096",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select iFrame height in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframe_height", 'value' => 'heightpixel' )
			),
			array(
				"type"             	 	=> "switch_button",
				"heading"			    => __( "Make iFrame Transparent", "ts_visual_composer_extend" ),
				"param_name"		    => "iframe_transparency",
				"value"				    => "true",
				"description"		    => __( "Switch the toggle if you want the iFrame to allow for transparency.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' )
			),
			// Border Settings
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "iFrame Border Type", "ts_visual_composer_extend" ),
				"param_name"        	=> "border_type",
				"width"             	=> 300,
				"value"             	=> array(
					__( "None", "ts_visual_composer_extend" )                          => "",
					__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
					__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
					__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
					__( "Double Border", "ts_visual_composer_extend" )                 => "double",
					__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
					__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
					__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
					__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
				),
				"description"       	=> __( "Select the border type for the iFrame.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' )
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "iFrame Border Thickness", "ts_visual_composer_extend" ),
				"param_name"        	=> "border_thick",
				"value"             	=> "1",
				"min"               	=> "1",
				"max"               	=> "10",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the thickness for the iFrame border.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "iFrame Frame Border Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "border_color",
				"value"             	=> "#000000",
				"description"       	=> __( "Select the color for the iFrame border.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
			),				
			array(
				"type"              	=> "switch_button",
				"heading"               => __( "Make iFrame Full-Width", "ts_visual_composer_extend" ),
				"param_name"            => "iframefullwidth",
				"value"                 => "false",
				"description"           => __( "Switch the toggle if you want attempt showing the iFrame in full width (will not work with all themes).", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' )
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Full iFrame Breakouts", "ts_visual_composer_extend" ),
				"param_name"            => "breakouts",
				"value"                 => "6",
				"min"                   => "0",
				"max"                   => "99",
				"step"                  => "1",
				"unit"                  => '',
				"description"           => __( "Define the number of parent containers the iFrame should attempt to break away from.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "iframefullwidth", 'value' => 'true' )
			),
			// Triggger Type
			array(
				"type"                  => "seperator",
				"param_name"            => "seperator_2",
				"seperator"             => "Trigger Settings",
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Trigger Type", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_trigger",
				"value"                 => array(
					__("Default Image", "ts_visual_composer_extend")          	=> "default",
					__("Custom Image", "ts_visual_composer_extend")           	=> "image",
					__("Font Icon", "ts_visual_composer_extend")              	=> "icon",
					__("Winged Button", "ts_visual_composer_extend")          	=> "winged",
					__("Simple Button", "ts_visual_composer_extend")          	=> "simple",
					__("Flat Icon Button", "ts_visual_composer_extend")       	=> "flaticon",
					__("Flat Button", "ts_visual_composer_extend")       		=> "flat",
					__("Text", "ts_visual_composer_extend")                   	=> "text",
					__("Custom HTML", "ts_visual_composer_extend")            	=> "custom",
				),
				"description"           => __( "Select the type of trigger to click on in order to show the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Trigger Settings",
			),
			// Custom Image
			array(
				"type"                  => "attach_image",
				"heading"               => __( "Select Image", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_image",
				"value"                 => "",
				"description"           => __( "Select the preview image for the lightbox content.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"             	 	=> "switch_button",
				"heading"			    => __( "Simple Image Only", "ts_visual_composer_extend" ),
				"param_name"		    => "content_iframe_image_simple",
				"value"				    => "false",
				"description"		    => __( "Switch the toggle if you want to display just the image without any styling.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'image' ),
				"group" 				=> "Trigger Settings",
			),
			// Font Icon
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Select Icon', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'content_iframe_icon',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon you want to display.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('icon', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),			
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Icon Size", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_iconsize",
				"value"                 => "30",
				"min"                   => "16",
				"max"                   => "512",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the icon / image size", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Icon Color", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_iconcolor",
				"value"                 => "#cccccc",
				"description"           => __( "Define the color of the icon.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'icon' ),
				"group" 				=> "Trigger Settings",
			),
			// Flat Button
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Color Style", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_buttonstyle",
				"width"                 => 300,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Default_Colors,
				"description"           => __( "Select the general color style for button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Button Hover Style", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_buttonhover",
				"width"                 => 300,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Hover_Colors,
				"description"           => __( "Select the general hover style for button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			// Button
			array(
				"type"                  => "textfield",
				"heading"               => __( "Button Text", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_buttontext",
				"value"                 => "View iFrame",
				"description"           => __( "Enter the text for the button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('winged', 'simple', 'flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Button Text Size", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_buttonsize",
				"value"                 => "16",
				"min"                   => "12",
				"max"                   => "20",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the font size for the trigger button.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			// Text Link
			array(
				"type"                  => "textfield",
				"heading"               => __( "Trigger Text", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_text",
				"value"                 => "",
				"description"           => __( "Enter the trigger text for the video.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'text' ),
				"group" 				=> "Trigger Settings",
			),
			// Custom Code
			array(
				"type"                  => "textarea_raw_html",
				"heading"               => __("Raw HTML", "ts_visual_composer_extend"),
				"param_name"            => "content_raw",
				"value"                 => base64_encode(""),
				"description"           => __("Enter your custom HTML code; code will be wrapped in appropriate link automatically.", "ts_visual_composer_extend"),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'custom' ),
				"group" 				=> "Trigger Settings",
			),
			// Other Shortcode
			array(
				"type"              	=> "textarea_raw_html",
				"heading"           	=> __( "Shortcode", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_shortcode",
				"value"             	=> base64_encode(""),
				"description"       	=> __( "Enter the shortcode that will render the modal trigger; make sure that the shortcode output does NOT render any links by itself.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => 'shortcode' ),
				"group" 				=> "Trigger Settings",
			),
			// Title + Subtitle
			array(
				"type"                  => "textfield",
				"heading"               => __( "Title", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_title",
				"value"                 => "",
				"description"           => __( "Enter a title for the lightbox content.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('image', 'default', 'preview', 'winged', 'flat', 'flaticon') ),
				"group" 				=> "Trigger Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Subtitle", "ts_visual_composer_extend" ),
				"param_name"            => "content_iframe_subtitle",
				"value"                 => "",
				"description"           => __( "Enter a subtitle for the lightbox content.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('winged') ),
				"group" 				=> "Trigger Settings",
			),
			// Lightbox Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_3",
				"seperator"				=> "Lightbox Settings",
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('image', 'default', 'preview', 'simple', 'icon', 'text', 'custom', 'winged', 'flat', 'flaticon') ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )                 	=> "auto",
					__( 'Set Width (%)', "ts_visual_composer_extend" )        	=> "widthpercent",
					__( 'Set Width (px)', "ts_visual_composer_extend" )       	=> "widthpixel",
				),
				"description"           => __( "Select how the maximum element width inside the lightbox should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width_percent",
				"value"                 => "100",
				"min"                   => "25",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the maximum element width inside the lightbox in percent.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_width", 'value' => 'widthpercent' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Width", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_width_pixel",
				"value"                 => "960",
				"min"                   => "1",
				"max"                   => "1920",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the maximum element width inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_width", 'value' => 'widthpixel' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto', "ts_visual_composer_extend" )                 	=> "auto",
					__( 'Set Height (%)', "ts_visual_composer_extend" )      	=> "heightpercent",
					__( 'Set Height (px)', "ts_visual_composer_extend" )      	=> "heightpixel",
				),
				"description"           => __( "Select how the maximum element height inside the lightbox should be determined.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height_percent",
				"value"                 => "100",
				"min"                   => "25",
				"max"                   => "100",
				"step"                  => "1",
				"unit"                  => '%',
				"description"           => __( "Select the maximum element height inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_height", 'value' => 'heightpercent' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Maximum Lightbox Height", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_height_pixel",
				"value"                 => "540",
				"min"                   => "100",
				"max"                   => "1080",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the maximum element height inside the lightbox in px.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_height", 'value' => 'heightpixel' ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Group Name", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_group_name",
				"value"                 => "",
				"description"           => __( "Enter a custom group name to manually build group with other non-gallery items; leave empty for non-grouping", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('image', 'default', 'preview', 'simple', 'icon', 'text', 'custom', 'winged', 'flat', 'flaticon') ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Transition Effect", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_effect",
				"width"                 => 150,
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
				"default" 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"std" 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_LightboxDefaultAnimation,
				"admin_label"           => true,
				"description"           => __( "Select the transition effect to be used for the iframe in the lightbox.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('image', 'default', 'preview', 'simple', 'icon', 'text', 'custom', 'winged', 'flat', 'flaticon') ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "dropdown",
				"heading"               => __( "Backlight Effect", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_backlight",
				"width"                 => 150,
				"value"                 => array(
					__( 'Auto Color', "ts_visual_composer_extend" )					=> "auto",
					__( 'Custom Color', "ts_visual_composer_extend" )				=> "custom",
					__( 'Transparent Backlight', "ts_visual_composer_extend" )     	=> "hideit",
				),
				"admin_label"           => true,
				"description"           => __( "Select the backlight effect for the image.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "content_iframe_trigger", 'value' => array('image', 'default', 'preview', 'simple', 'icon', 'text', 'custom', 'winged', 'flat', 'flaticon') ),
				"group" 				=> "Lightbox Settings",
			),
			array(
				"type"                  => "colorpicker",
				"heading"               => __( "Custom Backlight Color", "ts_visual_composer_extend" ),
				"param_name"            => "lightbox_backlight_color",
				"value"                 => "#ffffff",
				"description"           => __( "Define the backlight color for the lightbox image.", "ts_visual_composer_extend" ),
				"dependency"            => array( 'element' => "lightbox_backlight", 'value' => 'custom' ),
				"group" 				=> "Lightbox Settings",
			),
			// Tooltip Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_4",
				"seperator"				=> "Tooltip",
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"             	 	=> "switch_button",
				"heading"			    => __( "Use Advanced Tooltip", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_css",
				"value"				    => "true",
				"description"		    => __( "Switch the toggle if you want to apply an advanced tooltip to the trigger element.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "textarea",
				"heading"			    => __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_content",
				"value"				    => "",
				"description"		    => __( "Enter the tooltip content here (do not use quotation marks).", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_position",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Vertical,
				"description"		    => __( "Select the tooltip position in relation to the trigger.", "ts_visual_composer_extend" ),
				"dependency"		    => array( 'element' => "content_tooltip_css", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"		    => "content_tooltip_style",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Layouts,
				"description"		    => __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"dependency"		    => array( 'element' => "content_tooltip_css", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltipster_offsetx",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"		    => array( 'element' => "content_tooltip_css", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltipster_offsety",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"		    => array( 'element' => "content_tooltip_css", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),		
			// Other Settings
			array(
				"type"				    => "seperator",
				"param_name"		    => "seperator_5",
				"seperator"				=> "Other Settings",
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"            => "margin_top",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "nouislider",
				"heading"               => __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"            => "margin_bottom",
				"value"                 => "0",
				"min"                   => "0",
				"max"                   => "200",
				"step"                  => "1",
				"unit"                  => 'px',
				"description"           => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "textfield",
				"heading"               => __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"            => "el_id",
				"value"                 => "",
				"description"           => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "tag_editor",
				"heading"           	=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            => "el_class",
				"value"                 => "",
				"description"      		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>